/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerItem;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class InventoryCommands {
    private InventoryCommands() {
    }

    public static void registerInventoryCommands() {
        CTCommands.registerCommand(CTCommands.playerCommand("inventory", "Outputs the names of the item in your inventory", (player, stack) -> {
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inventory -> {
                String inventoryContents = IntStream.range(0, inventory.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0)).filter(it -> !it.func_190926_b()).map(MCItemStackMutable::new).map(MCItemStackMutable::getCommandString).collect(Collectors.joining("\n", "Inventory items\n", ""));
                CraftTweakerAPI.logDump(inventoryContents, new Object[0]);
                CommandUtilities.send(CommandUtilities.color("Inventory list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
            });
            return 0;
        }));
        CTCommands.registerCommand("inventory", CTCommands.playerCommand("tags", "Outputs the tags of the items in your inventory", (player, stack) -> {
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inventory -> {
                String inventoryContents = IntStream.range(0, inventory.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0)).filter(it -> !it.func_190926_b()).map(it -> Pair.of((Object)new MCItemStackMutable((ItemStack)it).getCommandString(), TagManagerItem.INSTANCE.getAllTagsFor(it.func_77973_b()))).map(it -> (String)it.getFirst() + '\n' + InventoryCommands.stringify((Collection)it.getSecond())).collect(Collectors.joining("\n", "Inventory item tags\n", ""));
                CraftTweakerAPI.logDump(inventoryContents, new Object[0]);
                CommandUtilities.send(CommandUtilities.color("Inventory tag list generated! Check the crafttweaker.log file!", TextFormatting.GREEN), player);
            });
            return 0;
        }));
    }

    private static String stringify(Collection<MCTag<Item>> tags) {
        if (tags.isEmpty()) {
            return "- No tags";
        }
        return tags.stream().map(MCTag::getCommandString).map(it -> String.format("- %s", it)).collect(Collectors.joining("\n"));
    }
}

